//	CDiskDos.h

#ifndef _H_CDiskDos
#define _H_CDiskDos

#include "CDisk.h"
#include "DosStructs.h"

class CDesktop;
class CDiskDos;

typedef	OSErr	(*ForEachBitmapSectorCB)(
	CDiskDos		*thiz, 
	Dos_SectorSpec	*sectorSpec, 
	Boolean			*free, 
	Boolean			*done, 
	void			*data);

typedef struct Dos_SectorStackRef	Dos_SectorStackRef;

typedef struct Dos_SectorStackRef {
	Dos_SectorStackRef	*nextP;
	Dos_SectorStackRef	*prevP;

	Dos_SectorSpec		sectorSpec;
	short				refCount;
	Boolean				dirtyB;
	Dos_Sector			sector;
} Dos_SectorStackRef;

class CDiskDos : public CDisk {

	public:	
	
	OSErr		IDiskDos(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec);
	
	virtual	void	Dispose(void);

	OSErr			FlushEntry(void);
	Dos_VtocSector	*GetMyEntry(void);

	virtual	OSErr		BuildFileTypeMenu(void);
	virtual	short		MenuItemToFileType(short menuItem, ushort *auxType);
	virtual	short		FileTypeToMenuItem(Byte fileType, short auxType);
	
	virtual	char		*GetName(char *buf);
	virtual	void		SetName(char *buf);
	
	/******************************/	
	OSErr				SectorStack_Add(
		Dos_SectorSpec		sectorSpec, 
		Dos_SectorStackRef	**sectorRefPP, 
		Dos_Sector			*copySectorP = NULL, 
		Boolean				emptySectorB = FALSE);
		
	OSErr				SectorStack_Remove(Dos_SectorStackRef *sectorRefP);
	Dos_SectorStackRef	*SectorStack_Find(Dos_SectorSpec sectorSpec);

	OSErr		GetSector(
		Dos_SectorSpec	sectorSpec, 
		Dos_Sector		**sectorPP, 
		Boolean			refB = FALSE);
		
	OSErr		SetSector(
		Dos_SectorSpec	sectorSpec, 
		Dos_Sector		*sectorP = NULL);
		
	OSErr		DisposeSector(
		Dos_SectorSpec	sectorSpec);
		
	OSErr		SetAndDisposeSector(
		Dos_SectorSpec	sector, 
		Dos_Sector		*sectorP = NULL);

	/******************************/	

	virtual ADFS_IconType		GetIconType(void);
	virtual char		*GetDescription(char *buf);

	OSErr		GetDiskSectorMap(
		Gen_DiskBitUnion	*diskMapP, 
		ushort				*numBootS, 
		Gen_SectorSpec		*bootListA0, 
		ushort				*numEmptyS, 
		Gen_SectorSpec		*emptyListA0, 
		ushort				*numMysteryS, 
		Gen_SectorSpec		*mysteryListA0);

	virtual	OSErr		GetEntryAlloc(
		Boolean				getAsBlocksB, 
		Gen_EntryAlloc	**sectorListH);

	virtual	OSErr		GetDiskDirectoryMap(
		Gen_DiskBitUnion	*diskMapP, 
		ushort				*numDirS, 
		Gen_SectorSpec		*dirListA0);
		
	virtual	OSErr		GetSectorMap(Gen_AllocMap **blockMapH);

	OSErr	ForEachBitmapSector(
		ForEachBitmapSectorCB	UserCB, 
		void					*data);
		
	virtual	ulong		GetVolumeSize(void);
	virtual	ulong		GetVolumeBytesUsed(void);
	virtual	OSErr		NewDisk_Completion(ADFS_NewDiskCompletionRec *recP);
	virtual	OSErr		Flush(void);
	virtual	OSErr		Purge(Boolean criticalB);
	
	OSErr			IsFreeSector(Dos_SectorSpec sectorSpec, Boolean *isFreeB);
	OSErr			GetFreeSector(Dos_SectorSpec *freeSectorSpec);
	OSErr			FreeSector(Dos_SectorSpec sectorSpec);
	OSErr			ReserveSector(Dos_SectorSpec sectorSpec);
	OSErr			ReserveNextFreeSector(Dos_SectorSpec *freeSectorSpec);
	OSErr			Dos_GetNextFreeTSSectorAlloc(
		Dos_DirEntry	*entryP, 
		Dos_SectorSpec	*curSectorSpecP, 
		Dos_SectorSpec	**sectorSpecH, 
		Boolean			*allocdBP0);

	ulong			GetVolumeMaxFileSize(ushort pro_fileTypeS);
	ulong			CalcBytesUsedByFile(ulong fileSize);
	void			SetTwirled(Boolean twirledB);	
	Boolean			GetTwirled(void);
	
	Gen_AllocSizeType		GetAllocSize(void);
	virtual	OSErr			ZeroUnused(void);
	
	/**************************************************/
	private:

	Dos_SectorStackRef	*i_cachedSectorsP;

	typedef CDisk _inherited;
};

#endif
